# 1 Short Description

The schemata package helps the creation of topical outlines that illustrate the breakdown of concepts and categories in academic texts from the late medieval to early modern periods.

# 2 Installing a Distro Package

One can find `nameauth` in one's current TeX distribution. See the appropriate documentation in TeXlive, MikTeX, MacTeX, Linux distro, BSD, etc. Use those tools to ensure that `nameauth` is installed. **You are done.**

# 3 Obtaining from CTAN

## 3.1 Getting the Package Archive

If not using the tools above, one can download `schemata.zip` from [CTAN](https://mirrors.ctan.org/macros/generic/schemata.zip). After downloading, unpack `schemata.zip` in an appropriate directory. Change to the directory containing the supplied files. The following files are included in the archive that is uploaded to CTAN:

| Filename         | Description                             |
| :--------------- | :-------------------------------------- |
| `schemata.dtx`   | commented style file; source file       |
| `Makefile`       | For use with GNU make; with source file |
| `schemata.eps`   | Image file for the manual; source file  |
| `schemata.sty`   | style file          (generated file)    |
| `schemata.pdf`   | Documentation       (generated file)    |
| `README.md`      | This file           (generated file)    |
| `schematest.tex` | Test file           (generated file)    |

## 3.2 Determining the Installation type

### 3.2.1 Read `Makefile` First

`Makefile` has an extensive comment on usage, as well as other helpful comments. It lists all required programs needed to use the GNU make file for installation in a POSIX-compliant environment, such as GNU/Linux, various BSDs, MacOS, and WSL or Cygwin on Windows.

Minimum required programs include `bash` or an equivalent shell (for which one must edit `Makefile`), and `make`, plus a TeX distribution. To distribute the package, one also requires at least `sed`, and `zip`.

### 3.2.2 POSIX Cases

If one is using a TeX distribution in a POSIX environment (MacOS, Linux distro, BSD, etc.) and has the required programs listed in `Makefile`, one may do one of the following:

1. Use GNU make to build and install. **Section 4.1**

2. Build and install manually. **Section 4.2**

### 3.2.3 Windows Cases

Windows offers the largest number of possibilities:

* Cygwin offers a POSIX environment and its own TeX distribution. Avoid installing another TeX distro via WSL or Windows native. **Section 4.1**

* WSL offers a POSIX environment and its own TeX distribution. Avoid installing another TeX distro via Cygwin or Windows native. **Section 4.1**

* Use `make` within either Cygwin or WSL to build this package for native Windows TeX distributions MikTeX or TeXlive. Install needed build components in either Cygwin or WSL, alongside either MikTeX or TeXlive, but not both distros. Avoid installing another TeX distro in either Cygwin or WSL.

    * One can use `make` to build this package. **Section 4.1.1**

    * Installation must be manual. **Section 4.2.2**

* Directly using native Windows TeX distributions (MikTeX or TeXlive)

    All building and installation must be manual. **Section 4.2**

* Other POSIX environments running under DOS, Windows, and other systems have not been tested and are not supported.

* `Makefile` contains tests that will mitigate some issues:

    * If a `.exe` extension is needed by programs used in the building process, that is detected automatically.

    * If `ltxfileinfo` does not exist, the make process will produce a zip file that avoids potential problems in Windows.

    * If `dvipdf` from Ghostscript is installed in a non-Windows environment, the make process will use that. Otherwise it will fall back to `dvipdfmx`.

    * When installing, the make process will check if the path to the install directory exists. If it does not, it will produce an error message and exit.

    If this error message occurs, which is more likely in Windows, please refer to installation of local packages in MikTeX [here](https://docs.miktex.org/manual/localadditions.html#id573803) and [here](https://miktex.org/kb/texmf-roots). Otherwise see the [TeX FAQ](https://www.texfaq.org/FAQ-privinst) and [this page](https://en.wikibooks.org/wiki/LaTeX/Installing_Extra_Packages).

Here is a table showing the feasibility of a few scenarios. Any case that is not mentioned below has not been tested and is not recommended.

| Build Env. | TeX Distro Platform | Make builds pkg/zip            | Make installs package           |
| :--------- | :------------------ | :----------------------------- | :------------------------------ |
| POSIX      | POSIX               | Yes<sup>1</sup>                | Yes                             |
| Cygwin     | Cygwin (packages)   | Not tested; likely<sup>1</sup> | Not tested; likely <sup>2</sup> |
| Cygwin     | MikTeX (Windows)    | Yes<sup>1, 3</sup>             | No;<sup>4</sup> do manually     |
| Cygwin     | TeXlive (Windows)   | Not tested; likely<sup>1</sup> | Not tested; do manually         |
| WSL        | WSL Linux packages  | Yes<sup>1</sup>                | Yes<sup>5</sup>                 |
| WSL        | MikTeX (Windows)    | Yes<sup>1, 3</sup>             | No;<sup>4</sup> do manually     |
| WSL        | TeXlive (Windows)   | Not tested; likely<sup>1</sup> | Not tested; do manually         |

<sup>1</sup> All dependencies must be met. Bear in mind possible MacOS issues.

<sup>2</sup> Installs only to Cygwin environment; not to Windows environment.

<sup>3</sup> The `make images` target using `pdfjam` likely will not work as desired. **Section 6.2.3 Images**

<sup>4</sup> Neither `ltxfileinfo` nor `kpsewhich` will give useful results; do a manual install.

<sup>5</sup> Installs only to WSL Linux distro environment; not to Windows environment.

# 4 Building and Installing

Regarding command line options longer than one letter, the programs included with major TeX distributions use either single dashes or GNU-style double dashes.

Here, for the sake of consistency, we use the GNU convention of single dashes with one-letter options and double dashes for longer options.

## 4.1 GNU `make` for Building and Installation

### 4.1.1 Build

In the directory where the files unpacked from the zip archive are located, type `make`. This will do a fresh build of the package using `pdflatex`. To add more options, use, e.g.: `make ADDOPTS="--synctex=1"`.

There is a make target, `make unpack`, that does not build the package. It only regenerates files from `schemata.dtx`.

### 4.1.2 Install

Currently, `Makefile` only installs into POSIX environments.

For individual use, one must have a TDS-compliant tree set up in order for installation to work. For more info in setting up those trees, see **Section 4.2.3** for the individual case and **Section 4.2.4** for the site-wide case.

For site-wide use, one must be able to get root privileges via `sudo`.

* Type `make inst` to install the package files in the user's personal TDS-compliant directory tree.

* Type `make install` to install the package files in the site-wide, local TDS-compliant directory tree. The user will be prompted for the `sudo` password.

### 4.1.3 Remove

The same constraints that apply to installation also apply to removal. If one can do the former, one can do the latter.

* Type `make uninst` to remove the package files in the user's personal TDS-compliant directory tree.

* Type `make uninstall` to remove the package files in the site-wide, local TDS-compliant directory tree. The user will be prompted for the `sudo` password.

`Makefile` will produce listings from the remaining texmf trees after uninstalling the package.

## 4.2 Manual Building and Installation

Unlike the case with the supplied `Makefile`, which automates adding extensions, in certain cases using Windows TeX distros, one may have to add the ".exe" extension to the programs.

### 4.2.1 Build

1. Using the unpacked files from the zip archive, we begin by creating the installation driver, unpacking additional files from `schemata.dtx`, and generating a copy of the documentation without the table of contents and cross-references:

        pdflatex --shell-escape --recorder --interaction=batchmode schemata.dtx

    a. We see the following main files:

    `Makefile`, `README.md`, `schemata.dtx`, `schemata.eps`, `schemata.ins`, `schemata.pdf`, `schemata.sty`, and `schematest.tex`.

    b. We also see the following temporary files:

    `schemata.aux`, `schemata.fls`, `schemata.glo`, `schemata.hd`, `schemata.idx`, `schemata.log`, `schemata.out`, `schemata.tmp`, and `schemata.toc`; also `schemata-eps-converted-to.pdf`.

2. Generate the TOC and cross-references within the documentation:

        pdflatex --recorder --interaction=nonstopmode schemata.dtx

3. Generate the index and glossary files using `makeindex`:

        makeindex -q -s gglo.ist -o schemata.gls schemata.glo
        makeindex -q -s gind.ist -o schemata.ind schemata.idx

    This adds three files: `schemata.gls`, `schemata.ilg`, and `schemata.ind`.

4. Integrate the glossary (list of changes) and index into the documentation. The second run updates the TOC:

        pdflatex --recorder --interaction=nonstopmode schemata.dtx
        pdflatex --recorder --interaction=nonstopmode schemata.dtx

    The list of files now looks like:

| Filename         | Description                    |
| :--------------- | :----------------------------- |
| `Makefile`       | for use with GNU make          |
| `schemata.dtx`   | commented style file           |
| `schemata.eps`   | Image file used for the manual |
|                  |                                |
| `README.md`      | this file                      |
| `schemata.pdf`   | package documentation          |
| `schematest.tex` | test file                      |
|                  |                                |
| `schemata.ins`   | installation driver            |
| `schemata.sty`   | style file                     |
|                  |                                |
| `schemata.aux`   | auxiliary file                 |
| `schemata.fls`   | shows files read               |
| `schemata.glo`   | raw glossary entries           |
| `schemata.gls`   | typeset glossary entries       |
| `schemata.hd`    |                                |
| `schemata.idx`   | raw index entries              |
| `schemata.ilg`   | `makeindex` log file           |
| `schemata.ind`   | typeset index entries          |
| `schemata.log`   | log file                       |
| `schemata.out`   | pdf bookmark/hypertext info    |
| `schemata.tmp`   | temp file used with fancyvrb   |
| `schemata.toc`   | table of contents info         |

Also, there is the automatically-generated `schemata-eps-converted-to.pdf`.

### 4.2.2 General Install Info

In order to perform manual installation, one should be familiar with the general information at the [TeX FAQ](https://www.texfaq.org/FAQ-installthings).

Different TeX distributions have somewhat different ways to store TDS-compliant configuration and package data. See, for example, for MikTeX [here](https://docs.miktex.org/manual/localadditions.html#id573803) and [here](https://miktex.org/kb/texmf-roots). Otherwise see the [TeX FAQ](https://www.texfaq.org/FAQ-privinst) and [this page](https://en.wikibooks.org/wiki/LaTeX/Installing_Extra_Packages).

The instructions below conform generally to a Unix-like system. There are some cases under Windows where this method may not work. For other non-POSIX systems, one will have to know the appropriate procedures and documentation as needed for those cases, which are not covered here.

The user must already have a TDS-compliant tree set up in order for installation to work. We assume that one knows how to become superuser, create directories, move files, and the like.

### 4.2.3 Install for a User

`TEXMFHOME` is an environment (shell) variable that points to the root of a TDS-compliant directory tree available to a user. To get its value on POSIX-compliant systems, use:

* `kpsewhich --var-value TEXMFHOME`

Quite often, `$TEXMFHOME` is equivalent to `$HOME/texmf`. The dollar sign in front of the variable denotes the value of the variable instead of its name. If `$HOME` is `/home/bob`, then `$TEXMFHOME` would be `/home/bob/texmf`. We can understand the following paths to be under this home directory.

| Path                                 | Files            |
| :----------------------------------- | :--------------- |
| `$TEXMFHOME/source/generic/schemata` | `schemata.ins`   |
|                                      | `schemata.dtx`   |
|                                      | `schemata.eps`   |
|                                      | `Makefile`       |
|                                      |                  |
| `$TEXMFHOME/tex/generic/schemata`    | `schemata.sty`   |
|                                      |                  |
| `$TEXMFHOME/doc/generic/schemata`    | `schemata.pdf`   |
| `$TEXMFHOME/doc/generic/schemata`    | `README.md`      |
| `$TEXMFHOME/doc/generic/schemata`    | `schematest.tex` |

Create the directories in the left-hand column, or the equivalent. For manual installation, move or copy the files in the right-hand column to their respective directories in the left-hand column. On older TeX distributions, run `mktexlsr` on `$TEXMFHOME` to complete the install process (current distributions may not need this).

### 4.2.4 Install Site-Wide

`TEXMFLOCAL` is a variable that points to the root of a TDS-compliant directory tree available to all users on a local site, system-wide installation. To get its value, use:

* `kpsewhich --var-value TEXMFLOCAL`

See the [TeX FAQ](https://www.texfaq.org/FAQ-what-TDS). We can understand the following paths to be under this local site, system-wide directory:

| Path                                  | Files            |
| :------------------------------------ | :--------------- |
| `$TEXMFLOCAL/source/generic/schemata` | `schemata.ins`   |
|                                       | `schemata.dtx`   |
|                                       | `schemata.eps`   |
|                                       | `Makefile`       |
|                                       |                  |
| `$TEXMFLOCAL/tex/generic/schemata`    | `schemata.sty`   |
|                                       |                  |
| `$TEXMFLOCAL/doc/generic/schemata`    | `schemata.pdf`   |
|                                       | `README.md`      |
|                                       | `schematest.tex` |

Create the directories in the left-hand column. For manual installation, move or copy the files in the right-hand column to their respective directories in the left-hand column. Change file ownership as needed. If needed, run `mktexlsr` with the appropriate permissions on `$TEXMFLOCAL` to complete the install process. See also the discussion on [this page](https://tex.stackexchange.com/questions/45231/how-to-install-system-wide-packages-without-requiring-an-ls-r-database-with-tex).

# 5 More on Package Building

* The package and manual build on current and older TeX distributions, being designed with that in mind.

* The documentation is built only with `pdflatex`. The test file can generate output with multiple formats.

* This release was tested on Linux (Pop! OS; vanilla TL, both current and 2017) and Windows 10 (MikTeX using shells from both Cygwin and WSL).

* The CTAN release was created with the current vanilla TL on Pop! OS. See also [this page](https://wiki.debian.org/TeXLive) for Debian-based systems. For Arch-based systems, the AUR has a package that takes care of dependencies.

* TeXlive versions are managed on Pop! OS using [tl-switch](https://github.com/ServusCarolus/tl-switch).

# 6 Testing

The file `schematest.tex` is designed to test this package on a wide variety of formats.

To test `schemata`, either test the files right after installing, or create a new testing directory. One then can copy the files from the TDS-compliant source dir and optionally, the documentation directory as well, or unpack the CTAN zip file into the test directory and build the package.

## 6.1 Using GNU `make`

The make file will not allow `make` to process `dvilualatex` as a target. For caveats regarding the `eplain` target, see below.

* Type `make test` to use `pdflatex` and Greek via `babel`.

* If one wants to change engines and re-test, type `make testclean`.

* One can add the value of ENGINE:

For Greek via `polyglossia`; requires `GFSDidot.otf`:
:
        make test ENGINE=xelatex
        make test ENGINE=lualatex

For Greek via `babel`:
        make test ENGINE=pdflatex (default)
        make test ENGINE=latex

For transliterated Greek:
        make test ENGINE=tex
        make test ENGINE=luatex
        make test ENGINE=dviluatex
        make test ENGINE=xetex
        make test ENGINE=eplain
        make test ENGINE=lollipop

* The `eplain` executable may not exist in some TeX distributions. If this is the case, `make` will use `pdftex` to load the eplain macros and process the test files.

* To add more options, use, e.g.:

        make test ADDOPTS="--synctex=1"

## 6.2 Manual Method

Using `dvilualatex` has more complicated setup prerequisites that go beyond the scope of this document. One would have to install TFM files generated from `GFSDidot.otf` or use a different font.

* Compile `schematest.tex`.

Shows Greek text via `polyglossia`; requires `GFSDidot.otf`:

        lualatex --interaction=nonstopmode schematest
        xelatex --interaction=nonstopmode schematest

Shows Greek text via `babel`:

        latex --interaction=nonstopmode schematest
        pdflatex --interaction=nonstopmode schematest

Shows transliterated Greek:

        tex --interaction=nonstopmode schematest
        pdftex --interaction=nonstopmode schematest
        luatex --interaction=nonstopmode schematest
        dviluatex --interaction=nonstopmode schematest
        xetex --interaction=nonstopmode schematest

        eplain --interaction=nonstopmode schematest

        lollipop --interaction=nonstopmode schematest

* If `eplain` is not available as a command in the shell, one can invoke `pdftex` thus:

        $ pdftex
        This is pdfTeX, Version 3.141592653-2.6-1.40.28 (TeX Live 2025) (preloaded format=pdftex)
        restricted \write18 enabled.
        **&eplain schematest

* Another step is used only when a `dvi` file is produced.

    We default to `dvipdfmx` in case Ghostscript is not installed. If Ghostscript is already installed, one may be able to use `dvipdf` instead, but this can depend on one's system and TeX distribution. If a file `schematest.out.ps` exists, one may delete it after creating the pdf file.

        dvipdfmx schematest

If one changes LaTeX engines, one first must remove all of the auxiliary files.

# 7 Copyright

Copyright (C) 2025 by Charles P. Schaum <charles[dot]schaum@comcast.net>

This file may be distributed and/or modified under the
conditions of the LaTeX Project Public License, either
version 1.3 of this license or (at your option) any
later version. The latest version of this license is in:

[https://www.latex-project.org/lppl.txt](https://www.latex-project.org/lppl.txt)

and version 1.3 or later is part of all distributions
of LaTeX version 2005/12/01 or later.

This work includes all source and generated files
described as such in this file, README.md.
