 %%% fr8hyph.ck
  %%
  %% 
  %% This file 7bit ascii. 
  %% It is NOT autonomous, since it uses the 
  %% coding-independant hyphenation file
  %% fr8hyph.src as source of the patterns.

  %% This file sets up 8bit French hyphenation patterns 
  %% from the coding independant fr8hyph.src, for use 
  %% with font systems using the Cork 1990 encoding 
  %% (series dc, ec etc.). It is also suitable for dm fonts and 
  %% other Cork-extended CM fonts, which may have \oe
  %% in either or both of the positions "1B (CM)
  %% or "F7 (Cork).  

  %% This polyvalence is achieved by admitting 
  %% patterns for both positions of \oe.  
  %% The position "1B is the ff ligature for the Cork norm
  %% which is never passed to TeX as a single character,
  %% (say by \ff). Note that, inversely, \oe is not to be typed 
  %% as  oe  for TeX; the latter does not cause a ligature

  %% If these circumstances change, this short file 
  %% can readily be altered.

  %% The grouping around the the body of this file
  %% assures that the net change induced 
  %% is to the hyphenation trie only.
  %% (Neglecting a dozen or so abandoned hash table entries.)

 \catcode`\<=0
 \catcode`\>=12
 \lccode`\'=`\' %%=`\' from Desarm'enien %
   %% USA value 0 would block hyphenation
   %% of  d'hyper\-bo\-li\-sa\-tion

 \def\set#1>#2{\edef\temp{\def\noexpand#1>{\string #2}
                      \catcode`#2=12\lccode`#2=`#2}\temp}

 %%% Table setting up the Cork encoding for French patterns
  %
 %% <ag> for <a-grave>
 \set<ag>^^e0  
 %% <eg> is <e-grave>
 \set<eg>^^e8 
 %% <ea> is <e-acute>
 \set<ea>^^e9 

 %% <ax> is <a-circumflex>
 \set<ax>^^e2 
 %% <ex> is <e-circumflex>
 \set<ex>^^ea 
 %% <ix> is <i-circumflex>
 \set<ix>^^ee 
 %% <ox> is <o-circumflex>
 \set<ox>^^f4 
 %% <ux> is <u-circumflex>
 \set<ux>^^fb 

 %% <id> is <i-dieresis>
 \set<id>^^ef 
 %% <od> is <o-dieresis>
 \set<od>^^f6 

 %% <cc> is <u-cedilla>
 \set<cc>^^e7 

 %% <oe> is <oe-ligature>
 \set<oe>^^f7 

  %%%%%%%%%%%%%%%%%%%%%

 \endinput

% fr8hyph.src
% version june 2nd, 1992. (Daniel Flipo)
% Coding-independant version LS 6-92
% NOT TO BE INPUT DIRECTLY
% SEE fr8hyph.ck or fr8hyph.mac for use.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% This is *NOT* an official GUTenberg distribution %%
%%   but my personal updated version of the 8bits   %%
%%   french hyphenation patterns.  (Daniel Flipo)   %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Hyphenation patterns for French
% from Jacques D'esarm'enien: how to run TeX in a French environment:
% hyphenation, fonts, typography. Tugboat, 5 (1984) 91-102.
% Modifications by Michael Ferguson (Tugboat, 10, 1989) (mjf),
% Norman Buckle (nb) and Justin Bur (jbb).
% Following modifications by Daniel Flipo (df):
% March 20, 92: addition of some missing uppercase codes
% June 1, 92  : add missing JD patterns (see TSI vol 5 No 4 1986)
% and check consistency with FRHYPH.TEX for MLTeX (Gould, Rennes)
% Patterns present in FRHYPH.TEX and not in original JD file are
% marked as `JD+'.
 %
 % Coding independant version LS 6-92
 % as requested by Michael Ferguson in his presentation
 % of the Cork norm Tugboat 11 (Nov. 1990) pages 514--6.
 % <ag> is <a-grave>
 % <ax> is <a-circumflex>
 % <eg> is <e-grave>
 % <ea> is <e-acute>
 % <ex> is <e-circumflex>
 % <ix> is <i-circumflex>
 % <id> is <i-dieresis>
 % <ox> is <o-circumflex>
 % <od> is <o-dieresis>
 % <ux> is <u-circumflex>
 % <cc> is <u-cedilla>
 % <oe> is <oe-ligature>
 % for example by
 % 
 %% Here are the substitutions that were used
 %% to derive this table from Flipo's Cork norm table
 % Change "^^e0" to "<ag>"       "a"
 % Change "^^e8" to "<eg>"       "a"
 % 
 % Change "^^e9" to "<ea>"       "a"
 % 
 % Change "^^e2" to "<ax>"       "a"
 % Change "^^ea" to "<ex>"       "a"
 % Change "^^ee" to "<ix>"       "a"
 % Change "^^f4" to "<ox>"       "a"
 % Change "^^fb" to "<ux>"       "a"
 % 
 % Change "^^ef" to "<id>"       "a"
 % Change "^^f6" to "<od>"       "a"
 % 
 % Change "^^e7" to "<cc>"       "a"
 % 
 % Change "^^f7" to "<oe>"       "a"
 % 
 
  \message{fr8hyph.tex french hyphenation patterns
                     of jun 2nd, 1992}


\patterns{
%front mjf patterns deleted and replaced by orininal JD patterns,
%see at the end of phonetic patterns (df jun92).
% Phonetic patterns
1ba
1b<ax>
1be
1b<ea>
1b<eg>
1b<ex>
1bi
1b<ix> % mjf jun88
1bo
1b<ox>
1bu
1b<ux>
1by
4be. % JD+ (df jun92)
4bes.
1b2l
4ble.
4bles.
1b2r
4bre.
4bres.
1ca
1<cc>a % df jun92 (c-cedilla)
1c<ax>
1ce
1c<ea>
1c<eg>
1c<ex>
1ci
1c<ix> % mjf jun88
1co
1<cc>o % df jun92 (c-cedilla)
1c<ox> % df jun92
%1ct % df jan92
1cu
1<cc>u % df jun92 (c-cedilla)
1c<ux>
1cy
1c<oe> % mjf jun88
4ce. % JD+ (df jun92)
4ces.
1c2h
4che.
4ches.
2chb
2chg
2chm
2chn
2chp
2chs
2cht
2chw % (instead of 2chv) df jun92
.ch4
4ch. % JD+ (df jun92)
ch2l
4chle.
4chles.
ch2r
4chre.
4chres.
% ck patterns missing (df jun92)
1c2k % JD+
4cke. % JD+
4ckes. % JD+
4ck. % JD+
2ckb % JD+
2ckf % JD+
2ckg % JD+
2ck3h % JD+ c2k3h in JD's file
2ckp % JD+
2cks % JD+
2ckt % JD+
1c2l
4cle.
4cles.
1c2r
4cre.
4cres.
1<cc>
1da
1d<ax>
1de
1d<ea>
1d<eg>
1d<ex>
1di
1d<ix> % mjf jun88
1do
1d<ox>
1du
1d<ux>
1dy
4de. % JD+ (df jun92)
4des.
d1d2h
1d2r
4dre.
4dres.
1fa
1f<ax>
1fe
1f<ea>
1f<eg>
1f<ex>
1fi
1f<ix> % mjf jun88
1fo
1f<ox>
1fu
1f<ux>
1fy
4fe. % JD+ (df jun92)
4fes.
1f2l
4fle.
4fles.
1f2r
4fre.
4fres.
1ga
1g<ax>
1ge
1g<ea>
1g<eg>
1g<ex>
1gi
1g<ix> % mjf jun88
1go
1g<ox>
1gu
1g<ux>
1gy
4ge. % JD+ (df jun92)
4ges.
4gue.
4gues.
1g2ha
1g2he
1g2hi
1g2ho
1g2hy
1g2l
4gle.
4gles.
1g2n
.sta2g3n % df jun92
wa2g3n % df jun92
4gne.
4gnes.
1g2r
4gre.
4gres.
1ha
1h<ax>
1he
1h<ea>
1h<eg>
1h<ex>
1hi
1h<ix> % mjf jun88
1ho
1h<ox>
1hu
1h<ux>
1hy
4he. % JD+ (df jun92)
4hes.
1j
2jk
4je. % JD+ (df jun92)
4jes.
1ka
1k<ax>
1ke
1k<ea>
1k<eg>
1k<ex>
1ki
1k<ix> % mjf jun88
1ko
1k<ox>
1ku
1k<ux>
1ky
4ke. % JD+ (df jun92)
4kes.
1k2h
%c2k3h % (df jun92) replaced by 2ck3h as on Gould
4kh. % JD+ (df jun92)
.kh4
1k2r
1la
1l<ax>
1l<ag> % (instead of 1l<O">) df jun92
1le
.seu2le % jbb (df jun92)
1l<ea>
1l<eg>
1l<ex>
1li
1l<ix> % mjf jun88
1lo
1l<ox>
1lu
1l<ux>
1ly
4le. % JD+ (df jun92)
4les.
% following patterns missing (df jun92)
il2l
l3lion
cil3l
ucil4l
rcil4l
vacil4l
gil3l
hil3l
lil3l
mil3l
<ea>mil4l
rmil4l
armil5l
mil4let
semil4l
vanil3lin
vanil3lis
capil3l
papil3la
papil3le
papil3li
papil3lom
pupil3l
cyril3l
ibril3l
piril3l
thril3l
pusil3l
boutil3l
distil3l
fritil3l
instil3l
.stil3l
vil3l
avil4l
uvil4l
uevil4l
chevil4l
xil3l
% end of missing
1ma
1m<ax>
1me
1m<ea>
1m<eg>
1m<ex>
1mi
1m<ix> % mjf jun88
1mo
1m<ox>
1mu
1m<ux>
1my
1m<oe> % mjf jun88
4me. % JD+ (df jun92)
4mes.
1na
1n<ax>
1ne
1n<ea>
1n<eg>
1n<ex>
1ni
1n<ix> % mjf jun88
1no
1n<ox>
1nu
1n<ux>
1ny
n1x % JD+ (df jun92)
1n<oe> % mjf jun88 % JD+ (df jun92)
4ne. % JD+ (df jun92)
4nes.
1pa
1p<ax>
1pe
1p<ea>
1p<eg>
1p<ex>
1pi
1p<ix> % mjf jun88
1po
1p<ox>
1pu
1p<ux>
1py
4pe. % JD+ (df jun92)
4pes.
4ph. % JD+ (df jun92)
1p2h
4phe.
4phes.
ph2l % JD+ (df jun92)
4phle. % JD+ (df jun92)
4phles. % JD+ (df jun92)
2phn
ph2r
4phre.
4phres.
2phs
2pht
.ph4
1p2l
4ple.
4ples.
1p2r
4pre.
4pres.
1q
4que.
4ques.
1ra
1r<ax>
1re
1r<ea>
1r<eg>
1r<ex>
1ri
1r<ix> % mjf jun88
1ro
1r<ox>
1ru
1r<ux>
1ry
4re. % JD+ (df jun92)
4res.
1r2h
4rhe.
4rhes.
1sa
1s<ax>
1se
1s<ea>
1s<eg>
1s<ex>
1si
1s<ix> % mjf jun88
1so
1s<ox>
1su
1s<ux>
1sy
1s<oe> % mjf jun88
4se. % JD+ (df jun92)
4ses.
1s2ch
4sch.
2schs
4sche.
4sches.
.sch4
.sh4
4sh. % JD+ (df jun92)
1s2h
2shm
2shr
2shs
4she.
4shes.
1ta
1t<ax>
1t<ag> % (instead of 1tO") df jun92
1te
1t<ea>
1t<eg>
1t<ex>
1ti
1t<ix> % mjf jun88
1to
1t<ox>
1tu
1t<ux>
1ty
4te. % JD+ (df jun92)
4tes.
1t2h
4th.
.th4
4the.
4thes.
th2l % (2thl in JD'original file) (df june92)
2thm
2thn
th2r
4thre. % JD+ (df jun92)
4thres. % JD+ (df jun92)
2ths
1t2r
4tre.
4tres.
1va
1v<ax>
1ve
1v<ea>
1v<eg>
1v<ex>
1vi
1v<ix> % mjf jun88
1vo
1v<ox>
1vu
1v<ux>
1vy
4ve. % JD+ (df jun92)
4ves.
1v2r
4vre.
4vres.
1wa
1we
1wi
1wo
1wu
4we. % JD+ (df jun92)
4wes.
1w2r
1za
1ze
1z<ea>
1z<eg>
1zi
1zo
1zu
1zy
4ze. % JD+ (df jun92)
4zes.
% following patterns missing (df jun92)
'a4
'<ax>4
'e4
'<ea>4
'<eg>4
'<ex>4
'i4
'<ix>4
'o4
'<ox>4
%'\"o2 % mjf what for??? df jun92
'u4
'<ux>4
'y4
2'2
id'
% end of missing patterns
% Note: in FRHYPH following patterns are added, why? (\lefthyphenmin=2)
% .a4 .<ax>4 .e4 .<ea>4 .<eg>4 .<ex>4 .i4 .<ix>4 .o4 .<ox>4 .u4 .<ux>4 .y4
d1s2
f1s2
g1s2
tung2s3 % JD+ (df jun92)
l1s2t
m1s2
e2s3ch
i2s3ch<ea>
i2s3chia
i2s3chio
% Etymological patterns
1alcool
i1algi
a2l1algi % JD+ (df jun92)
y1algi % JD+ (df jun92)
1a2nesth<ea>si
i1arthr
y1asth % JD+ (df jun92)
a1<eg>2dre
i1<eg>2dre
o1<eg>2dre % JD+ (df jun92)
1<ea>2drie % JD+ (df jun92)
1<ea>2drique
1<ea>2lectr
1<ea>2l<ea>ment
1<ea>2nerg
o1d2l % JD+ (df jun92)
2t3heur
2r3heur
3d2hal % JD+ (df jun92)
3d2houd
2s3hom
2r3hydr
1informat % df jun92
o1ioni
1m2n<eg>s % JD+ (df jun92)
1m2n<ea>si
1m2n<ea>mo
mon2t3r<ea>al % df jun92
1octet % df jun92
i1oxy
io1a2ct % JD+ (df jun92)
3ph2tal<ea>
3ph2tis
1p2neu
1p2n<ea>
1p2sych
1p2t<eg>r
1p2t<ea>r
1s2caph
1s2cl<ea>r
1s2cop
e2s3cop
<ea>pi2s3cop
<ea>pi3s4cope
di2s3co % instead of di2s3cop (dis-convenance, dis-courir...) (df jun92)
1s2lav
1s2lov
1s2patia
1s2perm
1s2por
1s2ph<eg>r
1s2ph<ea>r
1s2piel
1s2piros
1s2tandard
o1s2tas
eu1s2tat % JD+ (df jun92)
o1s2tat
pro2s3tat
i1s2tat
1s2tein
o1s2t<ea>ro
1s2tigm
o1s2tim
1s2tock
1s2tomos
o1s2tom
y1s2tom % JD+ (df jun92)
o1s2trad
o1s2tratu
o1s2triction
1s2troph
a2s3tro
apo2s3tr
u2s3tr
1s2tructu
1s2tyle
t1t2l % JD+ (df jun92)
.ab3r<ea>a % JD+ (df jun92)
.ae3s4ch % JD+ (df jun92)
.amino1a2c % JD+ (df jun92)
.ana3s4tr % JD+ (df jun92)
.anti1a2
.anti1e2
.anti2enne
.anti1<ea>2
.anti1s2
.apo2s3ta % JD+ (df jun92)
.as2ta % JD+ (df jun92)
% following patterns missing (df jun92)
'ab3r<ea>a
'ae3s4ch
'amino1a2c
'ana3s4tr
'anti1a2
'anti1e2
'anti2enne
'anti1<ea>2
'anti1s2
'apo2s3ta
'as2ta
% end of missing patterns
.bi1a2c
.bi1au
.bio1a2
.bi1u2
.bi2s1a2
chlo2r3a2c % JD+ (df jun92)
chlo2r3<ea>2t % JD+ (df jun92)
.ci2s1alp
co1acc
co1acq
co1a2d
co1ap
co1ar
co1assoc
co1assur
co1au
co1ax
co1ef % JD+ (df jun92)
co1en
co1ex
co1<ea>2
.con4 % df mar92
.cons4 % df mar92
.contre1s2c % JD+ (df jun92)
co2nurb % (instead of co2n1urb) df jun92
.co1o2 % (instead of colo2) df mai92
.co2o3lie
.cul4 % df jan92
.dacryo1a2 % JD+ (df jun92)
.d<ea>1a2
.d<ea>1io
.d<ea>1o2
% Following patterns are not original JD's, who changed them? why?
.d<ea>2s1a2
.d<ea>3s2a3cr
.d<ea>3s2astr
.d<ea>3s2a3tell
.d<ea>2s1<ea>2
.d<ea>3s2<ea>3gr
.d<ea>2s1e2
.d<ea>3s2ensib
.d<ea>3s2ert
.d<ea>3s2exu
.d<ea>2s3h
.d<ea>2s1i2
.d<ea>3s2i3d
.d<ea>3s2i3gn
.d<ea>3s2i3li
.d<ea>3s2i3nen% instead of .d<ea>3s2i3non (df jun92)
.d<ea>3s2invo
.d<ea>3s2i3r
.d<ea>3s2ist
.d<ea>2s1o2
.d<ea>3s2o3d<ea>
.d<ea>3s2o3l
.d<ea>3s2o3pil
.d<ea>3s2orm
.d<ea>3s2orp
.d<ea>3s2oufr
.d<ea>2s1<oe> % mjf jun88
.d<ea>1s2c
.d<ea>1s2p
.d<ea>1s2t
.d<ea>2s1u2n
% end of modifications
.di1a2c<ea>
.di1a2cid
dia2g3n
.di1ald
.di1a2mi
.di1a2tom % .di1a2tomi in JD's file df jun92
.di1e2n
.di2s3h
.dy2s1a2
.dy2s1i2
.dy2s1o2 % df jun92
.dy2s1u2
.dy2s3
.en1a2
'en1a2 % df jun92
en1i2vr
.en1o2
'en1o2 % df jun92
.eu2r1a2
'eu2r1a2 % df jun92
extra1
extra2c % JD+ (df jun92)
extra2i % JD+ (df jun92)
h<ea>mi1<ea>
h<ea>mo1p2t
hypera2
hyper<ea>2
hypere2 % df june 92
hyper<oe>2 % JD+ (df jun92)
hyperi2
hypero2
hypers2
hyperu2
hype4r1
hypo1a2
hypo1<ea>2
hypo1e2 % df jun92
hypo1i2
hypo1o2
hypo1u2
hypo1s2
.in1a2
.in2a3nit
.in2augur
.in1<ea>2
.in2<ea>3lucta % e -> <ea> df jun92
.in2<ea>3narra
.in1e2
.in2effab % df jun92
.in2ept
.in2er
.in2exora % df jun92
.in1i2
.in2i3miti
.in2i3q
.in2i3t
.in1o2
.in2o3cul
.in2ond
.in1s2tab
.in1u2
.in2uit
.in2u3l
% same patterns with ' missing (df jun92)
'in1a2
'in2a3nit
'in2augur
'in1<ea>2
'in2<ea>3lucta
'in2<ea>3narra
'in1e2
'in2effab
'in2ept
'in2er
'in2exora
'in1i2
'in2i3miti
'in2i3q
'in2i3t
'in1o2
'in2o3cul
'in2ond
'in1s2tab
'in1u2
'in2uit
'in2u3l
.intera2
.inter<ea>2
.intere2
.interi2
.intero2
.interu2
.inters2
.inte4r3
% same patterns with ' missing (df jun92)
'intera2
'inter<ea>2
'intere2
'interi2
'intero2
'interu2
'inters2
'inte4r3
la2w3re % df jun92
.ma2c3k % JD+ (df jun92)
.macro1s2c % JD+ (df jun92)
.ma2l1a2dres
.ma2l1a2dro
.ma2l1ais<ea>
.ma2l1ap
.ma2l1a2v
.ma2l1en
.ma2l1int
.ma2l1oc
.ma2l1o2d
.ma2r1x % JD+ (df jun92)
.m<ea>2g1oh
.m<ea>2sa % df jun92
.m<ea>3san % df jun92
.m<ea>2s1es % .m<ea>2ses in JD's file (df jun92)
.m<ea>2s1i % .m<ea>2si in JD's file (df jun92)
.m<ea>2s1u2s % .m<ea>2sus in JD's file (df jun92)
.m<ea>ta1s2ta
.milli1am % JD+ (df jun92)
.mono1a2
.mono1<ea>2
.mono1e2
.mono1i2
.mono1<id>2d<ea> % JD+ (df jun92)
.mono1o2 % momo -> mono df jun92
.mono1u2
.mono1s2
.no2n1obs
n3s2at. % JD+ (df jun92)
n3s2ats. % JD+ (df jun92)
o2b3long % JD+ (df jun92)
ombud2s3 % JD+ (df jun92)
omni1s2
.oua1ou % JD+ (df jun92)
'oua1ou % df jun92
.ovi1s2c % JD+ (df jun92)
'ovi1s2c % df jun92
oxy1a2
pal<ea>o1<ea>2
.pa2n1a2f
.pa2n1a2m<ea>
.pa2n1a2ra
.pa2n1is
.pa2n1o2ph
.pa2n1opt
.para1s2
.pa2r1a2che
.pa2r1a2ch<eg>
.pa2r3h<ea>
.per1a2
.per1<ea>2
.per1e2
.per1i2
.per1o2
.per1u2
per3h
.pe4r
p<ea>2n1ul
p<ea>2r1<ea>2q % JD+ (df jun92)
.p<ea>ri1os
.p<ea>ri1s2
.p<ea>ri2s3s
.p<ea>ri2s3ta
.p<ea>ri1u2
.phalan3s2t % JD+ (df jun92)
photo1s2
.phyto3ph2 % JD+ (df jun92)
.pluri1a % JD+ (df jun92)
poly1a2
poly1<ea>2
poly1<eg>2
poly1e2
poly1i2
poly1o2
poly1u2
poly1s2
.pos2t3h % instead of .pos2t3hy (df jun92)
.pos2t1in % JD+ (df jun92)
.pos2t1o2
.pos2t3r
.post1s2
.pr<ea>1a2
.pr<ea>2a3la % df jun92
.pr<ea>2au
.pr<ea>1<ea>2
.pr<ea>1e2
.pr<ea>1i2
.pr<ea>1o2
.pr<ea>1u2
.pr<ea>1s2
.pro1<ea>2
.prou3d2h % JD+ (df jun92)
.pro1s2c<ea>
.psycho1a2n % JD+ (df jun92)
.pud1d2l % JD+ (df jun92)
radio1a2 % df jun92
.re1s2
.re2s3cap
.re2s3cisi % df jun92
.re2s3ciso % df jun92
.re2s3cou
.re2s3cri
.re2s3pect
.re2s3pir
.re2s3plend
.re2s3pons
.re2s3quil
.re2s3s
.re2s3t
.re3s4tab
.re3s4tag
.re3s4tand
.re3s4tat
.re3s4t<ea>n
.re3s4t<ea>r
.re3s4tim
.re3s4tip
.re3s4toc
.re3s4top
.re3s4tr
.re4s5trein
.re4s5trict
.re4s5trin
.re3s4tu
.re3s4ty
.r<ea>1a2
.r<ea>2a3le
.r<ea>2a3lis
.r<ea>2a3lit
.r<ea>2aux
.r<ea>1<ea>2
.r<ea>1e2
.r<ea>2el
.r<ea>2er % JD+ (df jun92)
.r<ea>2<eg>r
.r<ea>1i2
.r<ea>2i3fi
.r<ea>1o2
.r<ea>1u2
.r<ea>2uss
.r<ea>tro1a2
sesqui1a2
st<ea>r<ea>o1s2
.su2b1a2
.su3b2alt
.su2b1<ea>2
.su3b2<ea>3r
.su2b1in % JD+ (df jun92)
.su2b3limin
.su2b3lin
.su2b3lu
sub1s2
.su2b1ur
supero2
supers2
supe4r1
.su2r1a2
su3r2ah
.su3r2a3t
.su2r1e2
.su3r2eau
.su3r2ell % instead of .su3r2e1l (df jun92)
.su3r2et
.su2r1<ea>2
.su2r3h
.su2r1i2m
.su2r1inf
.su2r1int
.su2r1of
.su2r1ox
tachy1a2 % JD+ (df jun92)
tchin3t2 % JD+ (df jun92)
t<ea>l<ea>1e2
t<ea>l<ea>1i2
t<ea>l<ea>1o2b
t<ea>l<ea>1o2p
t<ea>l<ea>1s2
thermo1s2
tran2s1a2
tran3s2act % should be tran2s3act ? (trans-action)
tran3s2ats
tran2s3h
tran2s1o2
tran2s3p
tran2s1u2
.tri1a2c
.tri1a2n
.tri1a2t
.tri1o2n % JD+ (df jun92)
archi1<ea>2pis
moye2n1<ax>2g
po1astre
uni1o2v % JD+ (df jun92)
uni1a2x % JD+ (df jun92)
v<ea>lo1s2ki
vol2t1amp
% last patterns put back in alphabetical order (df jun92)
}

 %%% end of fr8hyphen.src

 %%% Now the addition for the extended CM fonts.

 \set<oe>^^1b 

\patterns{%
 1c<oe> % mjf jun88
 1m<oe> % mjf jun88
 1n<oe> % mjf jun88 % JD+ (df jun92)
 1s<oe> % mjf jun88
 .d<ea>2s1<oe> % mjf jun88
 hyper<oe>2 % JD+ (df jun92)
 }

 \endgroup
 %%% end of fr8hyphen.ck
 \endinput


