/*
 *		Common routine for scalable/downloaded font of LIPS3 / ESCPage
 *								30 June	1992, written by SHIMA
 *                               1 Oct  1992, modified by OkI
 */

#define JTFMP_ID    (9<<8)		/* this definition is used in LBP.C, too */

#ifdef	FDOWN
/* LBP dependent factor. Change them in init() if necessary.*/
long max_dsize = 0x80000L;	/* download capacity (default 0.5M byte) */
int maxdwidth = 128;	/* download font width limit */
int maxdheight = 128;	/* download font height limit */
int maxdfont = 32;		/* num of kinds of download limit*/

/* program control valiables */
int d_mincount = 2;		/* minimal count of usage to download */
int f_download;			/* flag to download font
						   1: d_work()  2: d_resume()  3: work()  */
int f_jdwn;				/* flag to download Japanese font */
int f_cell;				/* flag to method to count memory */
long cur_dsize;			/* current downloaded size */
static int num_dfont;	/* current number of download fonts */
char *font_def;
int f_font_on_edge=0;	/* 1: on_edge_font is available */
int on_edge_font;		/* used in only 'LIPS3.C'. When it is TURE,
						   the font is on paper edge and printed by
						   using VD mode. */
# ifdef	JDWN
static int maxdjchar = 3276; /* # of maximal 2 byte characters downloaded  */
						/* 16K/5 = 3276								  */
int	dj_min;				/* minimal # of spaces to download 2 byte characters */
int dj_skip;			/* # to skip downloaded 1 byte fonts */

static int num_djchar;	/* # of total download 2 byte characters */
static uint dj_top_off;	/* offset in table of 2 byte characters */

extern FONT_INFO *font_info_root;
extern char far *djfont_top;
extern char far *djfont_last;
extern uchar dj_font_code;
extern uchar dj_code;
extern int f_assigned;
void rewrite_preamble_ptex(PREAMBLE *, uint, FONT_INFO *);
# endif

#endif

int weight_org;	/* kanji font weight default */

extern char ptex_d;	/* ptex direction: 0 = yoko, 1 = tate */
extern BOOL draw_boxpic;
extern DIMENSION dviout_dimension;
extern int f_first_split;

extern int k_scale;

#ifndef	NOTPIC_EXTENSION
/* externals from bitblt.c */
extern BOOL rotate;		/* \special{rt}ɂړE] */
extern int rot_angle;	/* \special{rt}ɂ]̊px */
void rotate_address(PIXEL *xp, PIXEL *yp);
#endif

extern PIXEL H1, V1;	/* pret.c ɂ镪ʂ̕A*/

#ifndef	NOTATEGAKI
extern int tategaki;	/* [ctO */

#endif

PIXEL sptopixel(SCALED_PT);
PIXEL vtopixel(SCALED_PT);
long jtfm_width(FONT_INFO *, int);
int chk_goth(FONT_INFO *);
SCALED_PT mult20(SCALED_PT, SCALED_PT);
PREAMBLE *get_font(uint *, FONT_INFO *);
char *get_fontname(FONT_INFO *);
JFM_DATA *jfm_read(FONT_INFO *font, int char_code);
static FONT_INFO *search_font_info(uint);
int p_out_char(PIXEL, PIXEL, FONT_INFO *, uint, PREAMBLE *);

KFONT *get_lbp_font(FONT_INFO *fontc, JFM_DATA *jtfm)
{
	int font_no, len, vh_ratio, fg, weight, cmp;
 	long tmp, tmp2;
	char *name, *pt;
	KFONT *kf;

	ENTER("get_lbp_font");

	fg = F_LBP;
	vh_ratio = f_vh_ratio;
	weight = weight_org;
	len = strlen(name = get_fontname(fontc));
	tmp = fontc->size_para / 250
			 * (int)((long)k_scale * (long)k_scale_l / 1000L)/4;

	/* cg(id:JTFMP_ID)̏ꍇ fontc->k_width ͊̍Ă */
	fontc->k_height = tmp2 = vtopixel(mult20(jtfm->height + jtfm->depth, tmp));
	fontc->k_width  = tmp = sptopixel(mult20(jtfm->width, tmp));

	/*
		f<name>=<shotai>{G}{H}{F}{S}{O};<vh_ratio>;<weight>;<dots>;<dots>;...
		can be omitted after any ;
	 */
	if ((pt = font_def) == NULL)
		goto org;
	/* ȉ̕ɃoOL悤Ȃ̂ŁAC */
	for (font_no = 2;;) {
rep:	while (*pt != 'f') {
			while (*pt != 0 && *pt != ';' && *pt != ':')
				pt++;
			if (*pt == 0)
				goto org;		/* IWĩtHggp */
			pt++;
		}

		if (strncmp(name, ++pt, len) == 0 && pt[len] == '=') {
			pt += len + 1;
			lbpf->data[font_no].no = atoi(pt);
			while (*pt >= '0' && *pt <= '9')
				pt++;
			for (;;) {
				switch (*pt) {
				  case 'G':
					  fg |= F_GOTH;
					  break;
				  case 'F':
					  fg |= F_FILL;
					  break;
				  case 'S':
					  fg |= F_SHADOW;
					  break;
				  case 'O':
					  fg |= F_OUTLINE;
					  break;
				  case 'H':
					  fg |= F_GGOTH;
					  break;
				  default:
					  goto next;
				}
				pt++;
			}
next:		while (*pt == ';' || *pt == ':')
				pt++;
			if (*pt >= '0' && *pt <= '9'){
				if ((vh_ratio = atoi(pt)) < 200 || vh_ratio > 5000){
					if (vh_ratio > 1){
						error(ILLEGAL_ARGS,"-p=..%s", pt);
						vh_ratio = 0;
					}
				}
			}
			else
				goto getf;		/* vh_ratio ȉȗ */
			while (*pt != 0 && *pt != ';' && *pt != ':')
				pt++;
			if (*pt != 0)
				pt++;
			if (*pt >= '0' && *pt <= '9')
				weight = atoi(pt);
			for (cmp = -1; *pt;) {
				while (*pt != 0 && *pt != ';' && *pt != ':'){
					if (*pt == '-'){
				  		if (fontc->k_width + atoi(pt) <= 0 && cmp > 0){
							pt++;
							goto match;
						}
					}
					pt++;
				}
				if (*pt != 0)
					pt++;
				if (*pt < '0' || *pt > '9')
					break;
				if (!(cmp = fontc->k_width - atoi(pt))){	
												/* dots v */
match:				if (vh_ratio == 1)
						RETURN(NULL);	/*w肵hbgsgp*/
					else if (vh_ratio == 0)
						goto getf;	/*w肵hbggp*/
					goto rep;	/* 0 ȊOł͎̎w */
				}
			}
			if (vh_ratio == 0)
				RETURN(NULL);	/*w肵hbgȊOgp*/
			goto getf;			/* ׂĂ̎w߂*/
		}
	}
org:							/* `̃tHg@W̃tHgg */
	font_no = (chk_goth(fontc)) ? 1 : 0;
getf:
	if (vh_ratio <= 1)
		vh_ratio = f_vh_ratio;	/* vh_ratio  0,1 ̂Ƃ */
	fontc->font_type = JLBP;
	fontc->f_goth |= fg;		/*^SVbN@tHg̃Zbg */
	/* select font */
	kf = fontc->ext.kdir = (KFONT *)marea(KFONT_SIZE);

	kf->width = tmp;
	kf->height = ((unsigned long)tmp2 * vh_ratio + 500L) / 1000L;

	if (fg & F_OUTLINE)
		fontc->k_width += k_width_adj;	/* Esc/page p̕␳ */

	kf->name = lbpf->data[kf->fh = font_no].font_name;

    /* tHĝł Depth Ăꍇ̂߂̕␳
       LIPS ̏ꍇ height  7.9% tHgグƗǂB
       JFM ɂ[␳ cg݃tHgł ̕␳ɂȂ
       A̕␳͕Kɑ΂ĐɍsȂȂ΂ȂȂB
       ۑɂ͂܂Ă kf->size g킹ĂB */
    kf->size = (int)(((long)(k_base_l) * kf->height + 500) / 1000L) - k_base_d;
    
    /*  TeX ̃x[XCɑ΂␳ -J  JFM ̏
       ɍsȂBł͐ݒ肵ȂB */
    kf->base = 0;

    /* cg݃tHg̏ꍇAset_font  width/height ւKvB*/
	(*lbpf->set_font) (fontc, kf, fg, weight, lbpf->data[font_no].no);
	maxdfont++;

	RETURN(kf);
}

long ptex_dpi_adj;

int p_out_char(PIXEL h, PIXEL v, FONT_INFO *font, uint code, PREAMBLE *pxl)
{
	int angle;			/* tHg̊px(deg.) */
/*	int jfont_size;	*/	/* tHg̕E̍őhbgTCY*/

	ENTER("p_out_char");
	/* we need the following for the use of FONT CACHE */
	if (font->font_type == UNKNOWN){
		JFM_DATA* jtfm;
		/* jtfm = jfm_read(font, 0x3021); */
		jtfm = jfm_read(font, 0);
		get_lbp_font(font, jtfm);
	}

	/*cg݁Eg݂ɂʒu␳D] cput (pret.c) 
    sȂĂCɈz*/
	/* JLBPłpreamble->height      *
	 * ckrbg}bvł̓hbg        *
	 * XP[uł CHARS/100inch    */

	angle = 0;
	if (ptex_d == 1) {			/* c̏ꍇ */
		if ((code & 0xff00)	&&
		   (font->f_goth & F_TATE)
		    || ((font->f_goth & F_TOPT) && font->font_type == JXL)){
#ifdef	JDWN
			if (font->font_type != JLBP)
				rewrite_preamble_ptex(pxl, code, font);
			h -= pxl->width - pxl->depth_offset - pxl->shift_right_ptex;
			v -= pxl->pitch_offset + pxl->shift_up_ptex - pxl->height;
#else
			h -= pxl->width - pxl->depth_offset;
			v -= pxl->pitch_offset - pxl->height;
#endif
		}
		else {
			h -= pxl->height - pxl->depth_offset;
			v -= pxl->pitch_offset;
			angle = 270;
		}
	}
	else {
		h -= pxl->pitch_offset;
		v -= pxl->depth_offset;
		if (code & 0xff00
#ifdef	JDWN
			&& f_assigned != 2
#endif
		) {
			v += pxl->height;
			if (tategaki) {
				h += pxl->width;
				angle = 90;
			}
		}
	}

#ifdef JDWN
	if (f_assigned == 2){				/* downloaded KANJI font */
#if	0
printf( "DJ(#%d %04X", font->font_code, code);
#endif
		code = dj_code;
		font = search_font_info(dj_font_code);
#if	0
printf( " <- #%d %02X)\n", font->font_code, code);
#endif
	}
#endif

	/* tHĝDepthł */
	if (draw_boxpic == 0 && (code & 0xff00) ){
		PIXEL tmp;
		tmp = (font->ext.kdir)->size;
		switch (angle){
		case 90  :h -= tmp; break;
#if 0	/* ȉ̂Q͂肦Ȃ̂ŗ */
		case 180 :v += tmp; break;
		case 270 :v += tmp; break;
#endif
		default  :v -= tmp; break;
		}
	}

#ifndef NOTPIC_EXTENSION
	if (rotate)
		rotate_address(&h, &v);
#endif

#ifndef	NOTPIC_EXTENSION
		angle += (360-rot_angle);
		angle %= 360;
#endif
	on_edge_font=0;
	/* ŏIIȌWLʂɓĂ邩H */
	if (f_font_on_edge){
		/* vǑlAwidth, height ̍ől font_size
		ȉL͈͂͂ݏoĂtHg͑S edge_font
		ƂĈ݂B */
		int font_size;
		if (code & 0xff00){
			font_size=(pxl->width > pxl->height)?
				pxl->width : pxl->height;
		}else{
			font_size = (maxdwidth > maxdheight)?
				maxdwidth:maxdheight;
		}
		font_size = font_size*3/2;
		if (h < -font_size || v < -font_size
		|| h >= dviout_dimension.output_width + font_size
		|| v >= dviout_dimension.output_height + font_size){
			return 0;
		}
		if (h < font_size || v < font_size 
		|| h >= dviout_dimension.output_width - font_size 
		|| v >= dviout_dimension.output_height - font_size){
			if (!(code & 0xff00)) return 1;
			on_edge_font++;
		}
	}else{
		if (h < 0 || v < 0
		|| h >= dviout_dimension.output_width
		|| v >= dviout_dimension.output_height){
			return 0;
		}
	}
	if  (!f_first_split) return 0;

	if  (ptex_d){
/* tHgŋ[c[hł...*/
/* ĂяoĂ̂ŁAtate_yoko[`œK */
/* oR[h炷Ƃ]܂B*/
		(*(lbpf->tate_yoko)) ((font->f_goth & F_TATE)?1:0);
	}
	else {
#ifndef NOTATEGAKI
		if ((tategaki) && (code & 0xff00)){
			(*(lbpf->tate_yoko)) (1);
		/* 1 : cR[hI      0 : R[hI */
		}
		else
#endif
			(*(lbpf->tate_yoko)) (0);	/* R[hI */
	}
	(*(lbpf->rotate)) (angle);

 	/* pre_put_char ͏L angle̐ݒQƂ(LIPS3)̂ŁAԂ */

	(*(lbpf->pre_put_char)) (font, pxl, &code, &h, &v);
#if	0
printf("Put <#%d %02X:(%d,%d)>\n", font->font_code, code, h, v);
#endif
	/* h,v ̓v^ŗL̕␳pre_put_charŎ󂯂\LB*/

	(*(lbpf->move_cap)) (v, h);
	if (code & 0xff00) {
		if (draw_boxpic) {
			(*(lbpf->drawbox)) (v, h, pxl->height, pxl->width, 1);
		}
		else {
			(*(lbpf->put_jis_font)) (code);
		}
	}
#ifdef	FDOWN
	else if (draw_boxpic) {
		(*(lbpf->drawbox)) (v, h, pxl->height, pxl->width, 2);
	}
	else {
		(*(lbpf->put_dl_font)) (code);
	}
#endif
	return 0;
}

#ifdef	FDOWN

# ifdef	JDWN
static FONT_INFO *search_font_info(uint fontcode)
{
	FONT_INFO *font;

	for (font = first_font_info; font; font = font->next_font )
		if (font->font_code == fontcode) break;
	return(font);
}
# endif

int calc_realsize(PREAMBLE *preamble, struct REAL_SIZE *size)
{
	int row, pos, byte_width;
	int data, i, j;
	BUFFER *pat;
	int left, right, top, bottom;

	byte_width = preamble->byte_width;

	pat = preamble->raster;
	for (row = 0; row < preamble->height; row++){
		for(pos = 0; pos < byte_width; pos++)
			if(*pat++) goto quit0;
	}

quit0:
	if ((bottom = top = row) >= preamble->height){
		top = left = right = bottom = 0;
		goto end;
	}

	pat = preamble->raster + byte_width*preamble->height;
	for (row = preamble->height - 1; row > bottom; row--){
		for(pos = 0; pos < byte_width; pos++){
			if(*--pat) goto quit1;
		}
	}
quit1:
	bottom = row;
	for (pos = data = 0; pos < byte_width; pos++){
		pat = preamble->raster + top*byte_width + pos;
		for (row = top; row <= bottom; row++){
			data |= *pat;
			pat += byte_width;
		}
		if (data) break;
	}

	for(i = 0, j = 0x80; !(j & data) && j; i++, j /= 2);
	left = pos * 8 + i;

	for (data = 0, pos = byte_width - 1; pos >= 0; pos--){
		pat = preamble->raster + top*byte_width + pos;
		for (row = top; row <= bottom; row++){
			data |= *pat;
			pat += byte_width;
		}
		if (data) break;
	}
	for(i = 7, j = 1; !(j & data) && i >= 0; i--, j *= 2);
	right = pos * 8 + i;
end:
	size->left = left;
	size->top = top;
	size->right = right + 1;
	size->bottom = bottom + 1;
	i = (right - left + 8)/8;
	j = bottom - top + 1 ;
	return(byte_width*preamble->height - i*j);
}

int d_download(FONT_INFO *dfont, int flag)
{
	uchar b;
	int i, j;
#ifdef	JDWN
	int dj_max, dj_num, dj_maxwidth, dj_maxheight;
	uint dj_size;
	long dj_total_send;
#endif
	uint tmp, dlsize;
	DL_INFO dl;
/*	BUFFER *pat; */
	uchar *dp;
	PREAMBLE *preamble;
	struct REAL_SIZE r_size;
	long total_mem;
#ifdef	JDWN
	DJFONT *djpt;
	FONT_INFO *djfont_info;
	uint dj_off[127];		/* Kanji font to be downloaded */
	long dj_total_off;
#endif

	ENTER("d_download");
	if(dfont == NULL){		/*	initialize parameters */
		cur_dsize = num_dfont = num_djchar = 0;
		return 0;
	}
	dl.mincharcode = -1;
	dl.total_mem = dl.total_send = dl.total_off = 0L;
	dl.maxheight = dl.maxwidth = dl.numoffonts =
#ifdef	JDWN
	dj_total_off = dj_num = dj_total_send = dj_maxwidth = dj_maxheight =
#endif
	0;

	dp = dfont->d_flag;
	/* 128(256) ̓A`Ă镶 1 Ă 8Bit~16Byte 
	   ̃tO */

	if (flag)
		dp += (128 >> 3);		/* 0`255 ̌㔼128_E */
	dfont->f_goth &= ~F_DWN;	/* for the character with code >= 128 */
	if (num_dfont >= maxdfont){
		/* ꕶ_E[hȂƂɂ */
#ifdef	JDWN
		if(flag < 0xff)
#endif
		for (i = 0; i < 16; i++)
			dp[i] = 0;
		RETURN(0);
	}
#ifdef	JDWN
	if (flag >= 0x100){
		dj_max = 127;
		goto rep;
	}
#endif

	for (i = j = 0; i < 16; i++) {
		for (b = 1; b != 0; b <<= 1) {
			if (dp[i] & b) {
				tmp = flag + j;
				preamble = get_font(&tmp, dfont);
				if (preamble->width > maxdwidth
					|| preamble->height > maxdheight
					|| dfont->font_type == VIRTUAL_FONT) {
					dp[i] &= ~b;
				}
				else {
					dl.numoffonts++;
					dl.total_send +=
						(long)preamble->byte_width * preamble->height;
					if (preamble->width > dl.maxwidth)
						dl.maxwidth = preamble->width;
					if (preamble->height > dl.maxheight)
						dl.maxheight = preamble->height;
					if (dl.mincharcode == -1)
						dl.mincharcode = j;
					dl.maxcharcode = j;
					dl.total_off += calc_realsize(preamble, &r_size);
				}
			}
			j++;
		}
	}
	dl.total_send += (*(lbpf->get_dlhsize)) (dl.numoffonts);
	dlsize = (dl.maxwidth+7)/8*dl.maxheight;
	dl.total_mem = (*(lbpf->get_dlhsize)) (dl.numoffonts)
		+ dlsize*(long)(dl.numoffonts);
	total_mem = (f_cell)?(dl.total_send - dl.total_off):dl.total_mem;

	/* _E[hf[^̑[eʂ̃`FbN */
#ifdef	JDWN
	if (cur_dsize + total_mem  > max_dsize) RETURN(1);
	cur_dsize += total_mem;

	if((dj_max = 127 - dl.numoffonts) < dj_min || num_dfont < dj_skip)
		goto end_dj;
rep:		/* search the top unresolved character */
	djpt = (DJFONT*)(djfont_top + dj_top_off);
	for(;;){
		if ((char far *)(djpt) >= djfont_last) goto end_dj;
		if (!(djpt->after & 1)) break;
		djpt++;
	}
	dj_top_off = (char far *)djpt - djfont_top;
	b = djpt->font_code;
			/* search the corresponding FONTO_INFO */
	djfont_info = search_font_info(b);
	if (djfont_info == NULL) goto end_dj;
	for( ; ; ){
		tmp = djpt->code;
		preamble = get_font(&tmp, djfont_info);
		if (djfont_info->font_type == JLBP){
				/* use font generated by LBP */
nodj:		while((char far *)djpt < djfont_last){
				if (djpt->font_code == b) djpt->after = 1;
				djpt++;
			}
			goto rep;
		}
		else{
#if	1
			if (djfont_info->f_goth & F_TATE){
				ptex_d = 1;
				rewrite_preamble_ptex(preamble, tmp, NULL);
				ptex_d = 0;
				if (preamble->rotate_ptex & 7){
					djpt->after = 3;
					goto nxtdj;
				}
			}
#endif
			if (preamble->width > maxdwidth || preamble->height > maxdheight)
				djpt->after = 3;
			else{
				djpt->after = 7;
				dj_off[dj_num++] = (char far *)djpt - djfont_top;
				dj_total_send +=
					preamble->byte_width * preamble->height;
				dj_total_off += calc_realsize(preamble, &r_size);
				if (preamble->width > dj_maxwidth)
					dj_maxwidth = preamble->width;
				if (preamble->height > dj_maxheight)
					dj_maxheight = preamble->height;
				if (dj_num >= dj_max) goto end_dj;
			}
				/* search the next unresolved character in the same font */
nxtdj:		do{
				if ((char far*)(++djpt) >= djfont_last) goto rep;
			}while( djpt->font_code != b );
		}
	}
end_dj:		/* _E[hf[^̑[eʂ̃`FbN */
	if(!dj_num)
		total_mem = 0;
	else{
		dj_total_send += (*(lbpf->get_dlhsize)) (dj_num);
		dj_size = (dj_maxwidth+7)/8*dj_maxheight;
		total_mem = (*(lbpf->get_dlhsize)) (dj_num) + dj_size*(long)dj_num
			+ (dj_size - dlsize)*(long)(dl.numoffonts);
	}
 	i = dl.numoffonts;
	if ( ((f_cell)? (dj_total_send - dj_total_off):total_mem)
		> max_dsize - cur_dsize
	  || num_djchar + dj_num > maxdjchar){
		dj_num = 0;
	}
	else{
		if (dl.maxwidth < dj_maxwidth)
			dl.maxwidth = dj_maxwidth;
		if (dl.maxheight < dj_maxheight)
			dl.maxheight = dj_maxheight;
		dl.total_send += dj_total_send;
		dl.total_mem += total_mem;
		dl.total_off += dj_total_off;
		cur_dsize += ((f_cell)?(dj_total_send-dj_total_off):total_mem);
		if (dj_num) dl.mincharcode = 0;
		dl.numoffonts += dj_num;
		num_djchar += dj_num;
		if (dl.numoffonts > dl.maxcharcode){
			dl.maxcharcode = dl.numoffonts;
			if (dl.maxcharcode < 0x20) dl.maxcharcode--;
		}
	}
	if (dl.numoffonts == 0) RETURN(flag & 0x100);

	num_dfont++;				/*_E[htHg̐ */
	error(DIRECT, "<%d:%d", dl.assign_num = dfont->font_code, i);
	if (dj_num > 0) error(DIRECT, "+%d>", dj_num);
	else error(DIRECT, ">");
	(*(lbpf->pre_download)) (dfont, &dl, num_dfont, flag & 0x80);
	djfont_info = font_info_root;

	for (i = -1, j = b = tmp = 0; j < 128; b <<= 1, j++) {
		if (b == 0) {
			b = 1;
			i++;
		}
		if (!(flag & 0x100) && (dp[i] & b)){
			(*(lbpf->download_rastor)) (dfont, &dl, j, flag);
		}else if (tmp < dj_num && j != 0x20){
			djpt = (DJFONT*)(djfont_top + dj_off[tmp++]);
			if (djfont_info->font_code != djpt->font_code)
				djfont_info = search_font_info(djpt->font_code);
			(*(lbpf->download_rastor)) (djfont_info, &dl, j, djpt->code - j);
			djpt->count = j + (flag & 0x80);
			djpt->before = dfont->font_code;
			djpt->after = 5;
		}
	}
#else
	if ((cur_dsize += dl.total_send) > max_dsize)
		RETURN(1);
	if (dl.numoffonts == 0)
		RETURN(flag);

	num_dfont++;				/*_E[htHg̐ */
	error(DIRCT, "<%d:%d>", dl.assign_num = dfont->font_code, dl.numoffonts);
	(*(lbpf->pre_download)) (dfont, &dl, num_dfont, flag);

	for (i = -1, j = b = 0; j < 128; b <<= 1, j++) {
		if (b == 0) {
			b = 1;
			i++;
		}
		if (dp[i] & b)
			(*(lbpf->download_rastor)) (dfont, &dl, j, flag);
	}
#endif
	(*(lbpf->post_download)) (dfont, &dl);
	if (!(flag & 0x100)) dfont->f_goth |= F_DWN;
	RETURN(0);
}

#endif

void pr_int2(uint num)
{
	pr_putc((uchar)(num >> 8));
	pr_putc((uchar)(num & 0xff));
}

void pr_int2n(uint num, int count)
{
	while(count-- > 0)
		pr_int2(num);
}

void pr_int4(long num)
{
	pr_putc(*((unsigned char *)&num + 3));
	pr_putc(*((unsigned char *)&num + 2));
	pr_putc(*((unsigned char *)&num + 1));
	pr_putc(*((unsigned char *)&num + 0));
}

void pr_putsc(char *str, int num)
	/* w肳ꂽ񂩂v^ɏo͂Dc͂O */
{
	while (num-- > 0 && *str != '\0')
		pr_putc(*str++);
	while (num-- >= 0)
		pr_putc(0);
}

int AtoI(char **str)
{
	int result=0;
	while (isdigit(**str)) {
		result = result * 10 + (**str - '0');
		(*str)++;
	}
	return result;
}
