#include <stdio.h>
#include <stdarg.h>
#include "dvi.h"
#include "dvilw.h"

static int  repeat_count;
static int  q;
static byte *p;
static char hex_char[]="0123456789ABCDEF";

#define EMIT_HEX(c) {pschar(hex_char[c>>4]); pschar(hex_char[c&15]);}
#define get_pk_nyb(p,q) ( ((q)=!(q))==0 ? *(p)++&15 : *(p)>>4)

static int pk_pnum(int dyn_f)
{
    int i;
    if ( (i=get_pk_nyb(p,q))==0 )
    {
	int j; i++;
	while ( (j=get_pk_nyb(p,q))==0 ) i++;
	while ( i-- ) j = (j<<4)+get_pk_nyb(p,q);
	return j-15+((13-dyn_f)<<4)+dyn_f;
    }
    if (i<=dyn_f) return i;
    if (i<14) return ((i-dyn_f-1)<<4) + get_pk_nyb(p,q) + dyn_f +1;
    if (i==14) repeat_count=pk_pnum(dyn_f);
    else repeat_count=1;
    return pk_pnum(dyn_f);
}


void def_char(pk_char *c, double hconv)
{
    int     dyn_f   = c->dyn_f;
    int     state   = !c->state;
    int     h       = (int)c->h;
    int     w       = (int)c->w;

    p  =  c->data;
    q  =  0;

    if (w==0 || h==0) return;
    repeat_count=0;

    psprint("[<");

    if (dyn_f==14)
    {
	register byte *pa = c->data;
	register byte  pm = 128;
	register int   pb = 7;
	register int   ww;
	register byte  lm;
	register int   lb;
	register int   the_byte;

	while(h--)
	{
	    lb=7; lm=128;
	    the_byte=0;
	    for (ww=w; ww--;)
	    {
		if (pm & *pa) the_byte |= lm;
		if (lb--) lm >>= 1;
		else { lb=7; lm=128; EMIT_HEX(the_byte) the_byte=0;}
		if (pb--) pm >>= 1;
		else { pb=7; pm=128; pa++; }
	    }
	    if (lb!=7) EMIT_HEX(the_byte)
	    if (readable) pschar('\n');
	}
    }
    else
    {
	register int    r=0, rep_mode=0;

	while( h > 0)
	{
	    register int   lm=128, lb=7, the_byte=0;
	    register int   ww;
	    register byte *rp;
	    register int   rq,rstate,rr;

	    rp=p; rq=q; rstate=state; rr=r;
	    for(ww=w; ww--;)
	    {
		if (r==0) { state=!state; r=pk_pnum(dyn_f); }
		r--;
		if (state) the_byte |= lm;
		if (lb--) lm>>=1;
		else { lb=7; lm=128; EMIT_HEX(the_byte) the_byte=0;}
	    }
	    if (lb!=7) EMIT_HEX(the_byte)
	    if (readable) pschar('\n');
	    h--;

	    if (rep_mode==0 && repeat_count) rep_mode=repeat_count+1;
	    repeat_count=0;
	    if (rep_mode)
	    {
		if (--rep_mode==0) continue;
		p=rp; q=rq; state=rstate; r=rr;
	    }
	}
    }
    pschar('>');
    psprint("%d %d %d %d %g] %d D\n",
	    (int)c->hoff,(int)c->voff,(int)c->w,(int)c->h,
	    (double)c->tfm*hconv,(int)c->cc);

}

void draw_rule(int x, int y, int w, int h)
{
    psprint("%d %d M %d %d B\n",x,y,w,h);
}

